import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/route/route.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/core/utils/util.dart';
import 'package:viser_remit/data/controller/localization/localization_controller.dart';
import 'package:viser_remit/data/controller/splash/splash_controller.dart';
import 'package:viser_remit/data/repo/auth/general_setting_repo.dart';
import 'package:viser_remit/data/services/api_client.dart';

class SplashScreen extends StatefulWidget {

  const SplashScreen({Key? key}) : super(key: key);

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends State<SplashScreen> {

  @override
  void initState() {

    MyUtils.onboardScreen();
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(GeneralSettingRepo(apiClient: Get.find()));
    Get.put(LocalizationController(sharedPreferences: Get.find()));
    final controller = Get.put(SplashController(repo: Get.find(),localizationController: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.gotoNextPage();
    });
  }

  @override
  void dispose() {
    MyUtils.allScreen();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SplashController>(
      builder: (controller) => Scaffold(
        backgroundColor: controller.noInternet ? MyColor.colorWhite : MyColor.primaryColor,
        body: Stack(
          children: [
            Align(
              alignment: Alignment.center,
              child: Image.asset(MyImages.appLogoCircle, height: 100, width: 100),
            ),
          ],
        ),
      ),
    );
  }
}
